/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.views;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.Parsers;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonHandler;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.OverlayView;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.View;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.NotNull;

public class DropDownList
extends View
implements ButtonHandler {
    protected OverlayView overlay;
    protected Button button;
    protected ScrollingList list;
    protected DataProvider dataProvider;
    protected Consumer<DropDownList> handler;
    protected int dropDownWidth;
    protected int dropDownHeight;
    protected int selectedIndex = -1;
    protected int dropDownFixX = 0;

    public DropDownList() {
    }

    public DropDownList(PaneParams params) {
        super(params);
        this.dropDownWidth = this.width;
        this.dropDownHeight = this.width;
        params.applyShorthand("dropDownSize", Parsers.INT, 2, a -> {
            this.dropDownWidth = (Integer)a.get(0);
            this.dropDownHeight = (Integer)a.get(1);
        });
        this.dropDownFixX = params.getInteger("dropfixx", this.dropDownFixX);
        this.button = Button.construct(params);
        this.button.putInside(this);
        this.overlay = new OverlayView();
        this.overlay.setVisible(false);
        this.overlay.setPosition(0, 0);
        this.list = new ScrollingList(params);
        if (params.getInteger("maxContentHeight", 0) != 0) {
            this.list.setMaxHeight(params.getInteger("maxContentHeight", 0));
        }
        this.list.setSize(this.dropDownWidth, this.dropDownHeight);
        this.list.setPosition(this.x + this.width / 2 - this.dropDownWidth / 2 + this.dropDownFixX, this.y + this.height);
        this.list.putInside(this.overlay);
        this.list.parseChildren(params);
        this.button.setHandler(this);
    }

    @Override
    public void onButtonClicked(@NotNull Button buttonIn) {
        if (buttonIn == this.button) {
            if (this.overlay.isVisible()) {
                this.close();
            } else {
                this.overlay.setSize(this.getWindow().getInteriorWidth(), this.getWindow().getInteriorHeight());
                this.overlay.putInside(buttonIn.getWindow());
                this.open();
            }
        } else {
            this.onButtonClickedFromList(buttonIn);
        }
    }

    public void close() {
        this.overlay.setVisible(false);
    }

    public void open() {
        this.refreshElementPanes();
        this.overlay.setVisible(true);
        this.overlay.setFocus();
    }

    private void onButtonClickedFromList(@NotNull Button buttonIn) {
        Text idLabel = buttonIn.getParent().findPaneOfTypeByID("id", Text.class);
        if (idLabel != null) {
            int index = Integer.parseInt(idLabel.getTextAsString());
            this.setSelectedIndex(index);
            this.close();
        }
    }

    public void refreshElementPanes() {
        this.list.refreshElementPanes();
        this.list.setSize(this.dropDownWidth, Math.min(this.list.getContentHeight(), this.dropDownHeight));
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int index) {
        if (index < 0 || index >= this.dataProvider.getElementCount()) {
            return;
        }
        this.selectedIndex = index;
        this.button.setText(this.dataProvider.getLabelNew(this.selectedIndex));
        if (this.handler != null) {
            this.handler.accept(this);
        }
    }

    public void selectPrevious() {
        if (this.dataProvider.getElementCount() == 0) {
            this.setSelectedIndex(0);
        } else {
            this.setSelectedIndex((this.selectedIndex + this.dataProvider.getElementCount() - 1) % this.dataProvider.getElementCount());
        }
    }

    public void selectNext() {
        if (this.dataProvider.getElementCount() == 0) {
            this.setSelectedIndex(0);
        } else {
            this.setSelectedIndex((this.selectedIndex + 1) % this.dataProvider.getElementCount());
        }
    }

    public void setDataProvider(DataProvider p) {
        this.dataProvider = p;
        this.list.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return DropDownList.this.dataProvider.getElementCount();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                DropDownList.this.updateDropDownItem(rowPane, index, DropDownList.this.dataProvider.getLabelNew(index));
            }
        });
        this.refreshElementPanes();
    }

    private void updateDropDownItem(@NotNull Pane rowPane, int index, IFormattableTextComponent label) {
        Button choiceButton = rowPane.findPaneOfTypeByID("button", Button.class);
        if (choiceButton != null) {
            Text idLabel = rowPane.findPaneOfTypeByID("id", Text.class);
            if (idLabel != null) {
                idLabel.setText((IFormattableTextComponent)new StringTextComponent(Integer.toString(index)));
            }
            choiceButton.setText(label);
            choiceButton.setHandler(this);
        }
    }

    @Override
    public void setVisible(boolean v) {
        this.button.setVisible(v);
    }

    @Override
    public void setEnabled(boolean e) {
        this.button.setEnabled(e);
        this.list.setEnabled(e);
    }

    @Override
    public void drawSelf(MatrixStack ms, double mx, double my) {
        this.button.drawSelf(ms, mx, my);
    }

    @Override
    public void drawSelfLast(MatrixStack ms, double mx, double my) {
        this.button.drawSelfLast(ms, mx, my);
    }

    @Override
    public boolean click(double mx, double my) {
        return this.button.click(mx, my);
    }

    @Override
    public boolean canHandleClick(double mx, double my) {
        return this.button.canHandleClick(mx, my);
    }

    public void setHandler(Consumer<DropDownList> h) {
        this.handler = h;
    }

    @Override
    public boolean isPointInPane(double mx, double my) {
        return super.isPointInPane(mx, my) || this.overlay.isVisible() && this.list.isPointInPane(mx, my);
    }

    public static interface DataProvider {
        public int getElementCount();

        @Deprecated
        public String getLabel(int var1);

        default public IFormattableTextComponent getLabelNew(int index) {
            return new StringTextComponent(this.getLabel(index));
        }
    }
}

